'use strict';


define(['jquery', 'sgSound', 'sgButtonsManager'], function($, sgSound, buttonsManager) {

	
	var app = {};

	app.init = function() {
		var $window = $(window);
		var pageIdxs = {};
		//var pageIdx = 0;
		var pageLen = 0;
		var $pageBtns = $("[data-sg-id=btn-page]"); //$(":regex(data-sg-id,\\b"+"btn-page"+"([0-9]{0,2}|Next|Prev)\\b)");
		if ($pageBtns.length) {
			var $pageItems = $("[data-sg-id=item-page]"); //$(":regex(data-sg-id,\\b"+"item-page"+"[0-9]{0,2}\\b)");
			$pageItems.each(function(i, e) {
				//음원속성이 있다면 프리로드
				sgSound.sg_sound(this, false);
			}).not("[data-sg-key=1]").hide();
			//pageLen = $pageItems.length;
			//console.log($pageItems);
			//console.log($pageBtns);
		};



		$pageBtns
			.each(function(i, e) {
				buttonsManager.btnInit(this);
				var $me = $(this);
				var options = $me.data("options");
				if (options.visible == true) $me.show();
				else if (options.visible == false) $me.hide();

				var groupkey = this.getAttribute("data-sg-group");
				var groupSelector = groupkey ? "[data-sg-group=" + groupkey + "]" : "";
				var pageIdx = pageIdxs[groupkey] = 0;

				var $nextbt = $("[data-sg-id=btn-page]" + groupSelector + "[data-sg-key=next]");
				var $prevbt = $("[data-sg-id=btn-page]" + groupSelector + "[data-sg-key=prev]");
				if (pageIdx - 1 < 0) {
					if ($nextbt.length) sg.enabled($nextbt.removeClass("off"));
					if ($prevbt.length) sg.disabled($prevbt.addClass("off"));
				} else if (pageIdx + 1 > pageLen - 1) {
					if ($nextbt.length) sg.disabled($nextbt.addClass("off"));
					if ($prevbt.length) sg.enabled($prevbt.removeClass("off"));
				} else {
					if ($nextbt.length) sg.enabled($nextbt.removeClass("off"));
					if ($prevbt.length) sg.enabled($prevbt.removeClass("off"));
				}
				//음원속성이 있다면 프리로드
				sgSound.sg_sound(this, false);
			})
			.click(function() {
				var $me = $(this);
				var options = $me.data("options");
				if (!options.enabled) return;

				//var idkey = $me.attr("data-sg-id").match( /([0-9]{0,2}|Next|Prev)$/ )[0];//this.id.match( /([0-9]{0,2}|Next|Prev)$/ )[0];
				//var idkey = this.dataset["sgKey"];
				var idkey = this.getAttribute("data-sg-key");
				var groupkey = this.getAttribute("data-sg-group");
				var groupSelector = groupkey ? "[data-sg-group=" + groupkey + "]" : "";
				var $page;
				var pageIdx = pageIdxs[groupkey];
				//console.log(pageIdx);

				var pageLen = $("[data-sg-id=item-page]" + groupSelector).length;

				var callFlag = false;

				if (idkey == "next") {
					if (pageIdx + 1 < pageLen) {
						if (groupkey) $pageItems.filter(groupSelector).hide();
						else $pageItems.hide();

						pageIdx++;
						$page = $pageItems.filter(groupSelector + "[data-sg-key=" + (pageIdx + 1) + "]");
						if ($page.length == 0) {
							throw groupSelector + "[data-sg-key=" + (pageIdx + 1) + "]" + "is none.";
						} else {
							$page.show();
							callFlag = true;
						}


					}
				} else if (idkey == "prev") {
					if (pageIdx - 1 >= 0) {
						if (groupkey) $pageItems.filter(groupSelector).hide();
						else $pageItems.hide();
						pageIdx--;
						$page = $pageItems.filter(groupSelector + "[data-sg-key=" + (pageIdx + 1) + "]");
						if ($page.length == 0) {
							throw groupSelector + "[data-sg-key=" + (pageIdx + 1) + "]" + "is none.";
						} else {
							$page.show();
							callFlag = true;
						}
					}
				} else {
					if (groupkey) $pageItems.filter(groupSelector).hide();
					else $pageItems.hide();
					pageIdx = parseInt(idkey, 10) - 1;
					$page = $pageItems.filter(groupSelector + "[data-sg-key=" + idkey + "]");
					if ($page.length == 0) {
						throw groupSelector + "[data-sg-key=" + idkey + "]" + "is none.";
					} else {
						$page.show();
						callFlag = true;
					}
				}

				//prev next버튼이 있을 때 active, deactive 처리
				var $nextbt = $("[data-sg-id=btn-page]" + groupSelector + "[data-sg-key=next]");
				var $prevbt = $("[data-sg-id=btn-page]" + groupSelector + "[data-sg-key=prev]");
				if (pageIdx - 1 < 0) {
					if ($nextbt.length) sg.enabled($nextbt.removeClass("off"));
					if ($prevbt.length) sg.disabled($prevbt.addClass("off"));
				} else if (pageIdx + 1 > pageLen - 1) {
					if ($nextbt.length) sg.disabled($nextbt.addClass("off"));
					if ($prevbt.length) sg.enabled($prevbt.removeClass("off"));
				} else {
					if ($nextbt.length) sg.enabled($nextbt.removeClass("off"));
					if ($prevbt.length) sg.enabled($prevbt.removeClass("off"));
				}

				pageIdxs[groupkey] = pageIdx;

				//console.log($page);

				//IE css렌더 버그.. line-height의 사이즈가 박스쉐도우의 그림자부분에 겹칠때, display:none을 해도 그림자가 남는현상 해결위한 선택.. 배경의 css랜더링위함
				$body.css("background-color", $body.css("background-color"));

				//window resize 이벤트를 수신하는 놈들을 위해 페이지 변경시, 디스패치
				$window.trigger("resize");

				if (callFlag) {
					sg_call($page[0]);
					//음원속성이 있다면 재생
					sgSound.sg_sound($page[0]);
				}

				sg_call(this);
				//음원속성이 있다면 재생
				sgSound.sg_sound(this);
			});

	}

	return app;
});