'use strict';

/**
 @author María Andre Cruz Blandón
*A module representing the custom zoom-abled element (tree of navigation and time-life)
*@Module sgPopUp  
*/

define(['jquery', 'zoomooz'], function($, zoomooz) {

	var app = {};

	app.init = function(){
		var $zoomElem = $('[data-sg-id=elem-zoom]');

		if($zoomElem.length==0) return;

		$zoomElem.each(function(e,i){
			var $me = $(this);
			$me.addClass('zoomViewport');
			var $idZoomElem = $me.attr('data-sg-key');
			$me.click(clickViewport);

			var $zoomScren = $me.find('[data-sg-id=zoom-screen]');

			if($zoomScren.length == 0){
				console.error('sgZoom: sg-elem-zoom should have a sg-zoom-screen child.');
				return;
			}else if ($zoomScren.length > 1){
				console.error('sgZoom: sg-elem-zoom should have just one sg-zoom-screen child.');
				return;
			}

			$zoomScren.addClass('zoomContainer');
			$zoomScren.click(clickViewport);

			var $zoomItems = $zoomScren.find('[data-sg-id=item-zoom]');

			$zoomItems.each(function(f,j){
				var $item = $(this);
				$item.addClass('zoomTarget');
				$item.zoomTarget();
				$item.click(clickTarget);
			});

			var $parent = $me.parent();

			var $zoomMenu = $parent.find('[data-sg-id=zoom-menu]');

			if($zoomMenu.length > 1){
				console.error('sgZoom: a sg-elem-zoom should have just one sg-zoom-menu');
				return;
			}

			var $refZoomMenu = $zoomMenu.attr('data-sg-ref');

			if($idZoomElem != $refZoomMenu){
				console.error('sgZoom: sg-zoom-menu have to have the sg-ref attribute equeal to sg-key of sg-elem-zoom')
			}

			var $zoomButtons = $zoomMenu.find('[data-sg-id=btn-zoom]');

			$zoomButtons.each(function(f,j){

				var $button = $(this);
				$button.addClass('zoomButton');
				$button.attr('data-root','.zoomViewport[data-sg-key='+$idZoomElem+']');
				
				/**
				* ZoomButtons have 3 different types: 
				* next 
				* prev
				* zoomOut
				*/

				var $type = $button.attr('data-sg-type');
				$button.attr('data-type',$type);
				$button.removeAttr('data-sg-type');

				if($type=='next'|| $type=="prev"){
					$button.zoomButton();					
				}
				if($type == 'zoomOut') {
					$button.click(clickButtonType);	
				}

				var $targetButton = $button.attr('data-sg-target-key');

				if($targetButton != undefined){
					$button.click(clickButtonTarget);
				}

			});
		});
		
	};

	app.initFunction = function(){
	};

	app.targetEventN = false;

	app.targetEvent = function(){		
	};

	app.updateZoom = function(){
		app.initFunction();

		$('[data-sg-id=elem-zoom]').each(function(e,i){
			var $container = $(this).find('[data-sg-id=zoom-screen]');
			var $targets = $container.find('[data-sg-id=item-zoom]');
			$targets.each(function(f,j){
				var $item = $(this);
				app.targetEventN ? $item.click(app.targetEvent): $item.one('click', app.targetEvent);
			});
		});
	};

	function clickButtonTarget(){
		var $me = $(this);

		var $targetKey = $me.attr('data-sg-target-key');
		var $target = $me.parent().parent().find('[data-sg-id=item-zoom][data-sg-key='+$targetKey+']');

		$target.click();

		$me.parent().find('.zoomButton[data-sg-target-key]').removeClass('active activeGroup');
		$me.addClass('active');

		var $group = $target.attr('data-sg-group');
		if($group != undefined){
			var $targets = $target.parent().find('[data-sg-id=item-zoom][data-sg-group='+$group+']');
			$targets.each(function(e,i){
				var $itemTargetKey = $(this).attr('data-sg-key');
				if($itemTargetKey != $targetKey){
					$me.parent().find('.zoomButton[data-sg-target-key='+$(this).attr('data-sg-key')+']').addClass('activeGroup');
				}
			});
		}
	};

	function clickButtonType(){
		var $button = $(this);
		var $type = $button.attr('data-type');

		var $root = $(this).attr('data-root');
		$($root).click();
		$button.parent().find(".zoomButton[data-sg-target-key]").removeClass('active activeGroup');
	};

	function clickTarget(){
		var $target = $(this);
		var $targetKey = $target.attr('data-sg-key');
		$target.parent().parent().parent().find(".zoomButton[data-sg-target-key]").removeClass('active activeGroup');
		$target.parent().parent().parent().find(".zoomButton[data-sg-target-key="+$targetKey+"]").addClass('active');

		var $group = $target.attr('data-sg-group');
		if($group != undefined){
			var $targets = $target.parent().find('[data-sg-id=item-zoom][data-sg-group='+$group+']');
			$targets.each(function(e,i){
				var $itemTargetKey = $(this).attr('data-sg-key');
				if($itemTargetKey != $targetKey){
					$target.parent().parent().parent().find('.zoomButton[data-sg-target-key='+$(this).attr('data-sg-key')+']').addClass('activeGroup');
				}
			});
		}

	};

	function clickViewport(){
		var $me = $(this);
		if($me.hasClass('zoomViewport'))
			$me.parent().find('[data-sg-id=zoom-menu]').find('.zoomButton').removeClass('active activeGroup');
		if($me.hasClass('zoomContainer'))
			$me.parent().parent().find('[data-sg-id=zoom-menu]').find('.zoomButton').removeClass('active activeGroup');
	}

	return app;
});