/**
 *@author Felipe Vargas South RIC
 *@Module That is a file for enabling the popover function for a text. The popover is showed in the top, left, right, bottom
 *  according to the attribute  data-popover-mode
 */

var initList = initList || [];

initList.push(function() {
     (function($) {

          $.fn.popover = function(options) {
               var set = $.extend({
                    'mode': 'right'
               }, options);
               var init= function(){
                    var parentDiv = $(this).offsetParent();
                              
                              

                              $('.popover').remove();

                              var mode = $(this).attr('data-popover-mode');
                              /*Changes the mode in the case that exists the param*/
                              if (mode) {
                                   set.mode = mode;
                              }
                              var out = '<div class="popover  ' + set.mode + '"  >' +
                                   '<div class="popover-content">'+'<div class="btn-close"></div> <div class="arrow"></div>'
                                    + $(this).attr('data-popover'); + ' </div></div>';

                              parentDiv.append(out);

                              popOver = parentDiv.find('.popover');
                              /*when the developer needs a custom position or style*/
                              var classCss= $(this).attr('data-popover-class');
                              if(classCss){
                                  
                                   popOver.addClass(classCss);
                              }
                              /*Look the position to put the popover near the text o element*/
                              var css;
                              switch (set.mode) {

                                   case 'right':
                                        {
                                             css = {
                                                  "left": this.offsetLeft + $(this).outerWidth() + 30,
                                                  "top": this.offsetTop + $(this).outerHeight() / 2 - popOver.outerHeight() / 2
                                             };


                                             break;
                                        }

                                   case 'left':
                                        {
                                             css = {
                                                  "left": this.offsetLeft - popOver.outerWidth() - 30,
                                                  "top": this.offsetTop + $(this).outerHeight() / 2 - popOver.outerHeight() / 2
                                             };
                                             break;
                                        }

                                   case 'top':
                                        {
                                             css = {
                                                  "left": this.offsetLeft + $(this).outerWidth() / 2 - popOver.outerWidth() / 2,
                                                  "top": this.offsetTop - popOver.outerHeight() - 30
                                             };
                                             break;
                                        }
                                   case 'bottom':
                                        {
                                             css = {
                                                  "left": this.offsetLeft + $(this).outerWidth() / 2 - popOver.outerWidth() / 2,
                                                  "top": this.offsetTop + popOver.outerHeight() - 30
                                             };
                                             break;
                                        }
                              }
                              popOver.css(css);
                              popOver.find('.btn-close').click(function() {
                                   popOver.remove();
                              });
               }
               /*Chose if the trigger is a event or it is directly*/
               if(set.trigger){
                    this.each(init);
               }else{
                    this.click(init);
               }   
          };

     })(jQuery);



});