var initList = initList || [];

initList.push(function() {

	require(['jquery.countdown'], function(jqCount) {
		var answers = [];
		var questions = [];
		var selections = [];

		var actContent = $('.act_content');

		var currentCityIndex = 0;
		var cities = $('.container-cities .city');
		var countCities = cities.length;
		var countries = actContent.find('.country');

		var questionContainer = actContent.find('.question-current');
		var spanCity = questionContainer.find('p');
		var containerResumen = actContent.find('.container-resumen').hide();
		var btnInit = actContent.find('.btn-init');
		var btnReinit = actContent.find('.btn-reinit');

		var containerInstructions=actContent.find('.container-instructions');
		var containerInstructionsImg=actContent.find('.container-img-instruction');
		var containerResumenImg=actContent.find('.container-img-resumen');
		var questionContainerImg=actContent.find('.container-img-quest');


		btnInit.click(
			function() {
				changeQuestion();
				var me = $(this);
				me.unbind('click');
				btnReinit.bind('click', restartGame);
				countries.bind('click',clickCountry);
				initTimer();

				// for hide the instructions 
				questionContainer.show();
				questionContainerImg.show();
				containerInstructions.hide();
				containerInstructionsImg.hide();


			}
		);

		function clickCountry() {
			var me = $(this);
			answers.push(me);
			me.css('opacity', '0.4');
			me.unbind('click');

			sg.sound("success-low");


			if (currentCityIndex == countCities) {
				console.log('entró '+currentCityIndex);
				createResumen();
				return;
			}
			changeQuestion();
		}


		function changeQuestion() {
			var currentCity = cities.eq(currentCityIndex);
			var textNameCity = currentCity.text();
			spanCity.text(textNameCity.trim());
			questions.push(currentCity);
			currentCityIndex++;
		}

		function createResumen() {
			chronometer.countdown360().stop();
			questionContainer.hide();
			questionContainerImg.hide();

			containerResumen.show();
			containerResumenImg.show();


			var goodAnsw=0;
			var htmlItemAnswer="";
			for (var i = 0; i < answers.length; i++) {
				var quest = questions[i];
				var answ = answers[i];

				var validation = wasBadAnswer(answ, quest);
				goodAnsw+=validation; 
				if(validation==1 ){
					htmlItemAnswer += "<label>" + quest.text() +": <span>" + answ.text() + "</span> </label>";
				}
				// containerResumen.append(htmlItemAnswer);
			}

			var limit=parseInt(countCities/2);


			var containerExcelent=containerResumen.find('.excelent').hide();
			var containerWrong=containerResumen.find('.wrong').hide();
			var containerGood=containerResumen.find('.good').hide();
			

			var selectedContainer;
			var message="";
			// goodAnsw=8;
			if(goodAnsw==countCities){
				selectedContainer=containerExcelent;
				message="¡Acertaste todas!";
				containerResumenImg.hide();
				sg.sound('claps');
			}
			else if(goodAnsw<limit){
				containerResumenImg.show();
				sg.sound('error');
				selectedContainer=containerWrong;
				if(goodAnsw==0){
					message="¡No tuviste aciertos inténtalo de nuevo!"
				}
				else if(goodAnsw==1){
					message="¡Solo tuviste <span>1</span> acierto inténtalo de nuevo!"
				}
				else {
					message="¡Solo tuviste <span>"+goodAnsw+"</span> aciertos inténtalo de nuevo!"
				}
			}else if(goodAnsw>=limit){
				containerResumenImg.hide();
				selectedContainer=containerGood;
				message="lograste <span>"+goodAnsw+"</span> aciertos";
				sg.sound('success');
			}
			// selectedContainer=containerExcelent;

			selectedContainer.show();
			selectedContainer.find('p.message-user-resumen').html(message);
			selectedContainer.find('.resumen-answers-funtions').html(htmlItemAnswer);

		}


		function wasBadAnswer(answer, quest) {

			if (answer.attr('data-sg-key') == quest.attr('data-sg-key')) {
				return 1;
			} else {
				return 0;
			}
		}

		function restartGame() {
			questionContainer.show();
			questionContainerImg.show();
			containerResumen.hide();
			containerResumenImg.hide();



			currentCityIndex = 0;
			questions.length = 0;
			answers.length = 0;

			changeQuestion();

			countries.unbind('click');
			countries.bind('click',clickCountry);
			countries.css('opacity', '1');
			initTimer();
		}



		function initTimer() {
			chronometer.countdown360().stop();
			chronometer.countdown360().start();
		}




		var chronometer = $('<div>').attr('id', 'chronometer');
		$('.container-chronometer').append(chronometer);

		chronometer.countdown360({
				radius: 60,
				seconds: 60,
				fontColor: '#FFFFFF',
				strokeStyle: '#E95720',
				fillStyle: '#EE7B1D',
				autostart: false,
				onComplete: function() {

					createResumen();
				}
			});

	});





});