/***********************
* Acciones de composición de Adobe Edge Animate
*
* Editar este archivo con precaución, teniendo cuidado de conservar 
* las firmas de función y los comentarios que comienzan con "Edge" para mantener la 
* capacidad de interactuar con estas acciones en Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // los alias más comunes para las clases de Edge

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         //tipo de actividad
         sym.setVariable("tipoactividad", "input");
         //Variables de colores
         sym.setVariable("border", "2px double #cccccc");
         sym.setVariable("fondo", "rgba(255,255,255,0.50)");
         sym.setVariable("colorini", "#666666");
         sym.setVariable("colorok", "#666666");
         sym.setVariable("fondook","rgba(169,200,88,0.50)");
         sym.setVariable("colorbad", "#ffffff");
         sym.setVariable("fondobad", "#f3716c");
         sym.setVariable("fontsize", "95px");
         sym.setVariable("lineheight", "0");
         sym.setVariable("fontFamily", "didact-gothic");
         sym.setVariable("fontStyle", "normal");
         sym.setVariable("fontweight", "bold");
         sym.setVariable("height", "auto");
         sym.setVariable("border-radius", "5px");

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_validar}", "click", function(sym, e) {
         //Definición de variables
         var Total=0;
         
         var tipoactividad = sym.getVariable("tipoactividad");
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         var colorbad = sym.getVariable("colorbad");
         var fondobad = sym.getVariable("fondobad");
         var wrong = '';
         
         for(i=1; i<=TotalInput; i++){
         	var y = (parseInt(sym.$("Input_"+i).css("top")) +0)+"px";
         	var x = (parseInt(sym.$("Input_"+i).css("left")) -25)+"px";
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){		
         		if(transformarTexto == true){
         			var ValorInput = $(this).val().toUpperCase();
         			var ValorTemp = sym.getVariable("Respuesta_"+i).toUpperCase(); 
         			//console.log('Input: '+ValorInput+'  -  Resp: '+ValorTemp);
         		}
         		else{
         			var ValorInput = $(this).val();
         			var ValorTemp = sym.getVariable("Respuesta_"+i);
         			//console.log('Input: '+ValorInput+'  -  Resp: '+ValorTemp);
         		}
         
         		if(ValorInput==ValorTemp){
         			$(this).css({color: colorok ,background: fondook});
         			//sym.$("ok"+i).css({top: y, left: x});
         			//sym.$("ok"+i).show();
         		}
         		else{
         			wrong = 1;
         			$(this).css({color: colorbad,background: fondobad});
         			//sym.$("bad"+i).css({top: y, left: x});
         			//sym.$("bad"+i).show();
         		}
         		$(this).attr('disabled','disabled');
         	}
         });
         }
         
         if (wrong == 1){
         	sym.$("resp_incorrecta").show();
         	//audio incorrecto
         	sym.$("error")[0].play();
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         }
         else{
         	//mensaje respuesta correcta
         	sym.$("resp_correcta").show();
         	//audio correcto
         	sym.$("success")[0].play();
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         }
         
         /*
         //Muestra las leyendas
         if(Total==TotalElementos){
         	//mensaje respuesta correcta
         	sym.$("resp_correcta").show();
         	//audio correcto
         	sym.$("success")[0].play();
         	//botones
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	sym.setVariable("intentos", 0);
         	//sym.$("txt_Respuesta").html (Total + "/" + Punteo);
         
         
         }
         else{
         	var totalintentos = sym.getVariable("totalintentos");
         	if (intento < totalintentos) {
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	//audio incorrecto
         	sym.$("error")[0].play();
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	intento = intento + 1;
         	sym.setVariable("intentos", intento);
         	}
         	else {
         	//mensaje respuesta incorrecta
         	sym.$("resp_incorrecta").show();
         	//audio incorrecto
         	sym.$("error")[0].play();
         	//botones
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").show();
         	sym.$("hotspot_reiniciar").show();
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("normal");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	//sym.$("txt_Respuesta").html (Total + "/" + Punteo);
         }
         }
         */

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_solucion}", "click", function(sym, e) {
         	sym.getSymbol("bt_validar").stop("down");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("normal");
         	sym.$("hotspot_validar").hide();
         	sym.$("hotspot_solucion").hide();
         	sym.$("hotspot_reiniciar").show();
         	
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         sym.$("comprobarRespuesta").hide();
         sym.$("Punteo").hide();
         
         for (var i=1; i<TotalInput; i++) {
               sym.$('ok'+i).hide();
         		sym.$('bad'+i).hide();
         }
         
         var colorok = sym.getVariable("colorok");
         var fondook = sym.getVariable("fondook");
         
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(i=1; i<=TotalInput; i++){
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){
         		var Resp = sym.getVariable("Respuesta_"+i);
         		$(this).val(Resp);
         		$(this).val().toUpperCase();
         		$(this).css({color: colorok ,background: fondook}
         		);
         	}
         	});
         }
         
         /*
         //Muestra las respuestas correctas
         sym.$("Input_01").children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_01"){
         		$(this).val(Valor_01);
         		$(this).css({color: colorok ,background: fondook}
         		);
         	}
         });
         */

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_reiniciar}", "click", function(sym, e) {
         //botones
         	sym.getSymbol("bt_validar").stop("normal");
         	sym.getSymbol("bt_solucion").stop("down");
         	sym.getSymbol("bt_reiniciar").stop("down");
         	sym.$("hotspot_validar").show();
         	sym.$("hotspot_reiniciar").hide();
         	sym.$("hotspot_solucion").hide();  
         //Oculta las leyendas
         sym.$("resp_correcta").hide();
         sym.$("resp_incorrecta").hide();
         
         
         for (var i=1; i<=TotalInput; i++) {
               sym.$('ok'+i).hide();
         		sym.$('bad'+i).hide();
         }
         
         var colorini = sym.getVariable("colorini");
         var fondoini = sym.getVariable("fondo");
         var tipoactividad = sym.getVariable("tipoactividad");
         
         for(i=0; i<=TotalInput; i++){
         	sym.$("Input_"+i).children(tipoactividad).each(function(){
         	if($(this).attr("id")=="seleccion_"+i){
         		$(this).val("");
         		$(this).css({color: colorini,background: fondoini});
         		$(this).removeAttr('disabled');
         	}
         });
         }

      });
      //Edge binding end

      

      

      

      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         //botones
         sym.getSymbol("bt_validar").stop("normal");
         sym.getSymbol("bt_solucion").stop("down");
         sym.getSymbol("bt_reiniciar").stop("down");
         sym.getSymbol("bt_ayuda").stop("normal");
         sym.$("hotspot_validar").show();
         sym.$("hotspot_solucion").hide();
         sym.$("hotspot_reiniciar").hide();
         sym.$("hotspot_ayuda").show();
         
         //Llammar variables creation Complete
         var tipoactividad = sym.getVariable("tipoactividad");
         var largo = "140px";
         var color = sym.getVariable("colorini");
         var border = sym.getVariable("border");
         var tamano = sym.getVariable("fontsize");
         var fontweight = sym.getVariable("fontweight");
         var lineheight = sym.getVariable("lineheight");
         var fontFamily = sym.getVariable("fontFamily");
         var fondo = sym.getVariable("fondo");
         var altura = sym.getVariable("height");
         var borderRadius= sym.getVariable("border-radius");
         
         transformarTexto = true; // Cambiar a false, si la actividad es de lenguaje o requiere validación exacta de las palabras 
         
         TotalInput = 5;
         
         // Agregar los input dinámicamente
         for (i=1 ; i<= TotalInput; i++){
         	var nombreElemento = 'Elemento_'+i;
         	nombreElemento = document.createElement(tipoactividad);
         	nombreElemento.id="seleccion_"+i;	 
         	nombreElemento.style.height= altura;
         	//nombreElemento.style.border= border;
         	nombreElemento.style.color= color;
         	nombreElemento.style.background= fondo;
         	nombreElemento.style.fontSize= tamano;
         	nombreElemento.style.fontWeight= fontweight;
         	nombreElemento.style.lineHeight= lineheight;
         	nombreElemento.style.fontFamily= fontFamily;
         	nombreElemento.style.textAlign="center";
         	nombreElemento.style.webkitBorderRadius=borderRadius;
         	nombreElemento.style.mozBorderRadius=borderRadius;
         	nombreElemento.style.borderRadius=borderRadius;
         	sym.$("Input_"+i).append(nombreElemento);
         }
         
         //RESPUESTAS -- CAMBIAR VALORES
         sym.setVariable("Respuesta_1", "o");
         sym.setVariable("Respuesta_2", "u");
         sym.setVariable("Respuesta_3", "i");
         sym.setVariable("Respuesta_4", "a");
         sym.setVariable("Respuesta_5", "e");
         sym.setVariable("Respuesta_6", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_7", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_8", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_9", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_10", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_11", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_12", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_13", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_14", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_15", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_16", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_17", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_18", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_19", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_20", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_21", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_22", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_23", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_24", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_25", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_26", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_27", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_28", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_29", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_30", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_31", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_32", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_33", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_34", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_35", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_36", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_37", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_38", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_39", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_40", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_41", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_42", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_43", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_44", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_45", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_46", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_47", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_48", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_49", "REEMPLAZAR POR VALOR");
         sym.setVariable("Respuesta_50", "REEMPLAZAR POR VALOR");
         
         /*	
         	Modifique el valor en pixels para el ancho de cada input según lo requiera
         */
         //seleccion_1.style.textTransform="uppercase";
         //seleccion_1.style.fontStyle="italic";
         seleccion_1.style.width= '175px';
         seleccion_1.style.border="2px double #62b6e7";
         seleccion_2.style.width= '175px';
         seleccion_2.style.border="2px double #ff6e96";
         seleccion_3.style.width= '175px';
         seleccion_3.style.border="2px double #99cd97";
         seleccion_4.style.width= '175px';
         seleccion_4.style.border="2px double #ac7ea9";
         seleccion_5.style.width= '175px';
         seleccion_5.style.border="2px double #ffa17a";
         seleccion_6.style.width= '175px';
         seleccion_7.style.width= '140px';
         seleccion_8.style.width= '140px';
         seleccion_9.style.width= '140px';
         seleccion_10.style.width= '140px';
         seleccion_11.style.width= '140px';
         seleccion_12.style.width= '140px';
         seleccion_13.style.width= '140px';
         seleccion_14.style.width= '140px';
         seleccion_15.style.width= '140px';
         seleccion_16.style.width= '140px';
         seleccion_17.style.width= '140px';
         seleccion_18.style.width= '140px';
         seleccion_19.style.width= '140px';
         seleccion_20.style.width= '140px';
         seleccion_10.style.width= '140px';
         seleccion_21.style.width= '140px';
         seleccion_22.style.width= '140px';
         seleccion_23.style.width= '140px';
         seleccion_24.style.width= '140px';
         seleccion_25.style.width= '140px';
         seleccion_26.style.width= '140px';
         seleccion_27.style.width= '140px';
         seleccion_28.style.width= '140px';
         seleccion_29.style.width= '140px';
         seleccion_30.style.width= '140px';
         seleccion_31.style.width= '140px';
         seleccion_32.style.width= '140px';
         seleccion_33.style.width= '140px';
         seleccion_34.style.width= '140px';
         seleccion_35.style.width= '140px';
         seleccion_36.style.width= '140px';
         seleccion_37.style.width= '140px';
         seleccion_38.style.width= '140px';
         seleccion_39.style.width= '140px';
         seleccion_40.style.width= '140px';
         seleccion_41.style.width= '140px';
         seleccion_42.style.width= '140px';
         seleccion_43.style.width= '140px';
         seleccion_44.style.width= '140px';
         seleccion_45.style.width= '140px';
         seleccion_46.style.width= '140px';
         seleccion_47.style.width= '140px';
         seleccion_48.style.width= '140px';
         seleccion_49.style.width= '140px';
         seleccion_50.style.width= '140px';
         //seleccion_1.style.fontStyle="italic";

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_hotspot_ayuda}", "click", function(sym, e) {
         if (sym.$("help_input").is(":visible")) {
         	sym.$("help_input").hide();
         	sym.getSymbol("bt_ayuda").stop("normal");
         } else {
         	sym.$("help_input").show();
         	sym.getSymbol("bt_ayuda").stop("down");
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Precargador'
   (function(symbolName) {   
   
   })("Precargador");
   //Edge symbol end:'Precargador'

   //=========================================================
   
   //Edge symbol: 'ok'
   (function(symbolName) {   
   
   })("ok");
   //Edge symbol end:'ok'

   //=========================================================
   
   //Edge symbol: 'bad'
   (function(symbolName) {   
   
   })("bad");
   //Edge symbol end:'bad'

   //=========================================================
   
   //Edge symbol: 'bt_validar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_validar");
   //Edge symbol end:'bt_validar'

   //=========================================================
   
   //Edge symbol: 'bt_solucion'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_solucion");
   //Edge symbol end:'bt_solucion'

   //=========================================================
   
   //Edge symbol: 'bt_reiniciar'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_reiniciar");
   //Edge symbol end:'bt_reiniciar'

   //=========================================================
   
   //Edge symbol: 'bt_ayuda'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

   })("bt_ayuda");
   //Edge symbol end:'bt_ayuda'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'bt_audio'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // introducir código aquí
         sym.stop();

      });
      //Edge binding end

      Symbol.bindElementAction(compId, symbolName, "${_ht_spot}", "click", function(sym, e) {
         var soundId = sym.getSymbolElement().attr( "title" );
         var currentAudio=sym.getComposition().getStage().$(soundId)[0].currentTime;
         var duracion= sym.getComposition().getStage().$(soundId).duration;
         console.log("soundId="+soundId);
         if (duracion== currentAudio){
         sym.stop("up");
         }
         
         sym.getComposition().getStage().$(soundId).on('ended', function() {
         sym.stop("up");
            // enable button/link
         });
         
         console.log("currentAudio="+currentAudio);
         console.log("duracion="+duracion);
         // Definir un conmutador para reproducir o pausar una pista de audio 
         if (sym.getComposition().getStage().$(soundId)[0].paused) {
         	sym.getComposition().getStage().$(soundId)[0].play();
         	sym.stop("down");
         
         } else {
         //activar para pausar en vez de reiniciar
         	sym.getComposition().getStage().$(soundId)[0].pause();
         	sym.stop("up");
         }

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         /*var soundId = sym.getSymbolElement().attr( "title" );
         var playing = false;
         $(soundId).bind("playing", function() {
            playing = true;
         // disable button/link
         });
         $(soundId).bind("ended", function() {
            playing = false;
         // enable button/link
         });
         
         // Mostrar un elemento 
         sym.$("ht_spot").bind("click", function() {
         if(!playing) {
         // Reproducir una pista de audio según el title de accesibilidad de este simbolo
         sym.getComposition().getStage().$(soundId)[0].play();
         sym.stop("down");
         }else{
         sym.getComposition().getStage().$(soundId)[0].currentTime = 0;
         sym.stop(0);
         }
         });*/
         
         

      });
      //Edge binding end

   })("bt_audio");
   //Edge symbol end:'bt_audio'

})(jQuery, AdobeEdge, "EDGE-94063035");